<?php
    $ip_address = $_SERVER['REMOTE_ADDR'];
    $user_agent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Okänd';
?>
<!DOCTYPE html>
<html lang="sv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Spårbarhetstest</title>
    <style>
        body { font-family: sans-serif; padding: 20px; line-height: 1.6; background-color: #f4f4f4; }
        .container { max-width: 800px; margin: auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h1 { color: #333; }
        pre { background: #eee; padding: 15px; border-radius: 5px; white-space: pre-wrap; word-wrap: break-word; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Information utan JavaScript</h1>
        <p>Denna sida visar information som kan samlas in från din webbläsare, även om JavaScript är inaktiverat.</p>

        <h2>Din IP-adress:</h2>
        <pre><?php echo htmlspecialchars($ip_address); ?></pre>

        <h2>Din User-Agent:</h2>
        <pre><?php echo htmlspecialchars($user_agent); ?></pre>

        <h2>Alla HTTP-headrar:</h2>
        <pre><?php
            foreach (getallheaders() as $name => $value) {
                echo "<b>" . htmlspecialchars($name) . "</b>: " . htmlspecialchars($value) . "\n";
            }
        ?></pre>

        <p>Återgå till <a href="index.html">huvudsidan</a> för det fullständiga testet.</p>
    </div>
</body>
</html>

